﻿/*
VERSION:	1.1

DECRIPTION:
	This system is meant to be used with the  tileWalk.as  style of movement.
	It collides with other movieClips on the sprite layer.
	
NOTE:
	If a sprite contains "noCollide" and it's set to true,
	then it won't collide with the player.

AVAILABLE DATA:
	This returns a collision function which changes its parent's objects & properties.
	The parent collision system (this) contains:
		xOffset, yOffset
		player_mc
			_x, _y
		collision_array
		walk_obj
			xVel, yVel
	
*/
function makeSpriteCollision()
{
	var collision_funct = function()
	{
		// extract velocities
		var xVel = this.walk_obj.xVel;
		var yVel = this.walk_obj.yVel;
		
		// get player's current tile
		var xPlayer = Math.floor(this.player_mc._x / 16);
		var yPlayer = Math.floor(this.player_mc._y / 16);
		
		// get destination tile
		var xDest = xPlayer + xVel;
		var yDest = yPlayer + yVel;
		
		// check for collision with all sprites
		var collision = false;
		for(var nam in this.spriteLayer_mc)
		{
			var thisSprite = this.spriteLayer_mc[nam];
			if(thisSprite.noCollide != true)
			{// if:  this sprite's collision is enabled
				// get sprite's tile
				var xTile = Math.floor(thisSprite._x / 16);
				var yTile = Math.floor(thisSprite._y / 16);
				// check whether a collision is immenent
				if( xDest == xTile  &&  yDest == yTile)
				{// if:  a collision will occur
					collision = true;
					break;	// stop checking sprites
				}// if:  a collision will occur
			}// if:  this sprite's collision is enabled
		}// for:  every sprite
		
		// if:  a collision will occur
		if( collision == true )
		{
			// cancel all velocities
			this.walk_obj.xVel = 0;
			this.walk_obj.yVel = 0;
		}// if:  collision is imminent
	}// collision_funct()
	
	return collision_funct;
}// makeSpriteCollision()
